//	--------------------------------------------------------------------------
//#version unofficial MegaPov 1.21;



//	--------------------------------------------------------------------------
#include "colors.inc"
#include "transforms.inc"
#include "chars.inc"

#declare generateFile = false;


//	--------------------------------------------------------------------------
#declare scatter_land = plane {y,0}
#declare total_objects =20;
#declare x_accuracy=20;   // letters need much more precision
#declare z_accuracy=20;
#declare file_name = "letters.inc"   
#declare RS=seed(0); 



//	--------------------------------------------------------------------------
#macro scatter_object_macro (N)
	#switch (N)
		#case (1)
			object { char_A rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
		#break
		#case (2)
			object { char_E rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
		#break
		#case (3)
			object { char_I rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
		#break
		#case (4)
			object { char_O rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
		#break
		#case (5)
			object { char_U rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
		#break
		#case (6)
			object { char_Y rotate 90*x pigment {rgb 0.5+0.5*<rand(RS),rand(RS),rand(RS)>} scale 0.5}
		#break
	#end   
#end



//	--------------------------------------------------------------------------
#macro position_macro()
	vtransform (3*rand(RS)*x, transform {rotate 360*rand(RS)*y})
#end  



//	--------------------------------------------------------------------------
#declare height_accuracy= 0.005;
#declare max_height=0.5;



//	--------------------------------------------------------------------------
#if (generateFile)
	#include "dispersion.mcr"
	scatter_multiple (6,file_name)  
#end
#include "letters.inc"
//	--------------------------------------------------------------------------


#declare Location = <-2, 3, -4>*2;
#declare Look_at = <0, 0, 0>;

camera {
	location  Location
	look_at   Look_at
	}

sky_sphere {
	pigment { rgb <0.6, 0.8, 1> }
	}

light_source {
	<4, 5, -5>*2
	rgb <1, 1, 1>*2.5	
	fade_power 2
	fade_distance 10
	}

//	--------------------------------------------------------------------------
plane {
	y, 0 
	pigment { checker White,White*0.90 scale 10}
	finish { ambient 0.40 diffuse 0.60 specular 0.2 roughness 0.015 reflection 0.2 }
	}
